#include <iostream>
#include <vector>
#include <stack>
#include <algorithm>

using namespace std;

int nadji_rastojanje_ako_je_k_poz(int tr_x, int tr_y, int x2, int y2){
	int x_presecne_tacke = (x2 - (y2 - tr_y));
	return abs(x_presecne_tacke - tr_x);
}

int nadji_rastojanje_ako_je_k_neg(int tr_x, int tr_y, int x2, int y2){
	int x_presecne_tacke = (x2 + (y2 - tr_y));
	return abs(x_presecne_tacke - tr_x);
}

struct jarbol{
	int x;
	int y;
	int i;
};

int main(){
	int n;
	cin >> n;
	vector<jarbol> niz(n);
	for(int i = 0; i < n; i++){
		cin >> niz[i].x;
		niz[i].i = i; 
	}
	for(int i = 0; i < n; i++){
		cin >> niz[i].y;
	}
	
	sort(niz.begin(), niz.end(), [](const jarbol& a, const jarbol& b){
		return a.x < b.x;
	});
	
	vector<int> visi_sa_desna(n, -1);
	vector<int> visi_sa_leva(n, -1);
	
	stack<jarbol> jarboli;
	for(int i = 0; i < n; i++){
		while(!jarboli.empty() && jarboli.top().y < niz[i].y){
			jarboli.pop();
		}
		if(!jarboli.empty()){
			visi_sa_desna[niz[i].i] = nadji_rastojanje_ako_je_k_poz(niz[i].x, niz[i].y, jarboli.top().x, jarboli.top().y);
		}
		jarboli.push(niz[i]);
	}
	
	stack<jarbol> jarboli1;
	for(int i = n-1; i >= 0; i--){
		while(!jarboli1.empty() && jarboli1.top().y < niz[i].y){
			jarboli1.pop();
		}
		if(!jarboli1.empty()){
			visi_sa_leva[niz[i].i] = nadji_rastojanje_ako_je_k_neg(niz[i].x, niz[i].y, jarboli1.top().x, jarboli1.top().y);
		}
		jarboli1.push(niz[i]);
	}

	vector<int> konacni(n);
	for(int i = 0; i < n; i++){
		int leva = visi_sa_leva[i];
		int desna = visi_sa_desna[i];
		
		if(leva == -1 && desna == -1) konacni[i] = -1;
		else if(leva == -1) konacni[i] = desna;
		else if(desna == -1) konacni[i] = leva;
		else konacni[i] = min(leva, desna);
	}

	for(int i = 0; i < n; i++){
		cout << konacni[i] << '\n';
	}
	
	return 0;
}